/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ModerateModifier
extends NoLevelsModifier {
    private static final float BASELINE_TEMPERATURE = 1.0f;
    private static final float MAX_BOOST = 7.5f;
    private static final Component MINING_SPEED = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)new ResourceLocation("tcintegrations", "moderate.mining_speed")));

    private static float getBonus(Player player, BlockPos pos) {
        float biomeTemp = ((Biome)player.f_19853_.m_204166_(pos).m_203334_()).m_47528_(pos);
        return 7.5f - Math.abs(1.0f - biomeTemp) * 4.4f;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + ModerateModifier.getBonus(event.getPlayer(), event.getPos()) * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus;
        if (tool.hasTag(TinkerTags.Items.HARVEST) && (bonus = player != null && key == TooltipKey.SHIFT ? ModerateModifier.getBonus(player, player.m_142538_()) : 7.5f) > 0.01f) {
            this.addFlatBoost(MINING_SPEED, bonus * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED), tooltip);
        }
    }
}

